/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.binarization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class Cutpoints
implements Serializable {
    private static final long serialVersionUID = 3660537629035514316L;
    private Vector<Cutpoint> mCutpoints = new Vector();

    public void addCutpoint(int indiceC, double novoCorte) {
        this.mCutpoints.add(new Cutpoint(indiceC, novoCorte));
    }

    public void narrowDown(ArrayList<Integer> indices) {
        Vector<Cutpoint> newList = new Vector<Cutpoint>();
        for (Integer index : indices) {
            newList.add(new Cutpoint(this.attAt(index), this.valueAt(index)));
        }
        newList.trimToSize();
        this.mCutpoints = newList;
    }

    public int attAt(int index) {
        int caracteristica = -1;
        if (index >= 0 && index < this.numCutpoints()) {
            caracteristica = this.mCutpoints.get(index).mAtt;
        } else {
            System.err.println("Call to attAt() before data is sorted.");
        }
        return caracteristica;
    }

    public double valueAt(int index) {
        double valor = -1.0;
        if (index >= 0 && index < this.numCutpoints()) {
            valor = this.mCutpoints.get(index).mValue;
        } else {
            System.err.println("Call to valueAt() with an invalid index: " + index + ".");
        }
        return valor;
    }

    public int numCutpoints() {
        return this.mCutpoints.size();
    }

    public void sort() {
        Collections.sort(this.mCutpoints);
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.mCutpoints.size()) {
            s = String.valueOf(s) + this.mCutpoints.get(i).toString() + "\n";
            ++i;
        }
        return s;
    }

    private class Cutpoint
    implements Serializable,
    Comparable<Cutpoint> {
        private static final long serialVersionUID = 4895475778132616358L;
        private final int mAtt;
        private final double mValue;

        public Cutpoint(int att, double aCorte) {
            this.mAtt = att;
            this.mValue = aCorte;
        }

        @Override
        public int compareTo(Cutpoint arg0) {
            if (arg0 != null) {
                if (arg0.mAtt < this.mAtt) {
                    return 1;
                }
                if (arg0.mAtt > this.mAtt) {
                    return -1;
                }
                if (arg0.mValue < this.mValue) {
                    return 1;
                }
                if (arg0.mValue > this.mValue) {
                    return -1;
                }
            }
            return 0;
        }

        public String toString() {
            return " [ att" + this.mAtt + " : " + this.mValue + " ]";
        }
    }
}

